package coreservlets;

import javax.servlet.http.*;
import org.apache.struts.action.*;

/** Komponent bean formularza dla danych rejestracyjnych. 
 *  Struts automatycznie wypeni komponent bean
 *  wartociami parametrw z otrzymanego dania.
 *  Klasa wskazuje domylne wartoci pl wejciowych.
 *  <P>
 *  Taken from Core Servlets and JavaServer Pages Volume II
 *  from Prentice Hall and Sun Microsystems Press,
 *  http://volume2.coreservlets.com/.
 *  (C) 2007 Marty Hall, Larry Brown, and Yaakov Chaikin;
 *  may be freely used or adapted.
 */

public class ContactFormBean extends ActionForm {
  private String firstName = "Imi";
  private String lastName = "Nazwisko";
  private String email = "uytkownik@komputer";
  private String faxNumber = "xxx-yyy-zzzz";
  private String[] defaultValues =
    { firstName, lastName, email, faxNumber };
  private String warning = "";

  public String getFirstName() {
    return(firstName);
  }

  public void setFirstName(String firstName) {
    this.firstName = firstName;
  }

  public String getLastName() {
    return(lastName);
  }

  public void setLastName(String lastName) {
    this.lastName = lastName;
  }

  public String getEmail() {
    return(email);
  }

  public void setEmail(String email) {
    this.email = email;
  }

  public String getFaxNumber() {
    return(faxNumber);
  }

  public void setFaxNumber(String faxNumber) {
    this.faxNumber = faxNumber;
  }

  public String getWarning() {
    return(warning);
  }

  public void setWarning(String baseWarning) {
    this.warning =
      "<H2><FONT COLOR=RED>Brak lub bdne " +
      baseWarning + "!</FONT></H2>";
  }

  public void clearWarning() {
    warning = "";
  }

  // Metoda reset poniej jest wymagana TYLKO jeeli komponent
  // bean dziaa w zasigu sesji. Wicej informacji na ten temat
  // w rozdziale na temat weryfikacji poprawnoci danych.

  public void reset(ActionMapping mapping,
                    HttpServletRequest request) {
    clearWarning();
  }

  public boolean isMissing(String value) {
    if ((value == null) || (value.trim().equals(""))) {
      return(true);
    } else {
      for(int i=0; i<defaultValues.length; i++) {
        if (value.equals(defaultValues[i])) {
          return(true);
        }
      }
      return(false);
    }
  }
}
